VERSION 4.00
Begin VB.Form Form1 
   Caption         =   "NEDImage VB Demo"
   ClientHeight    =   4755
   ClientLeft      =   1635
   ClientTop       =   1905
   ClientWidth     =   5355
   Height          =   5445
   Icon            =   "Form1.frx":0000
   Left            =   1575
   LinkTopic       =   "Form1"
   ScaleHeight     =   4755
   ScaleWidth      =   5355
   Top             =   1275
   Width           =   5475
   Begin MSComDlg.CommonDialog CommonDialog2 
      Left            =   3960
      Top             =   2520
      _Version        =   65536
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   0
      CancelError     =   -1  'True
      DialogTitle     =   "Save Image As"
      Filter          =   $"Form1.frx":030A
   End
   Begin NEDImage.NEDImage NEDImage1 
      Height          =   6615
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   9615
      _Version        =   65536
      _ExtentX        =   16960
      _ExtentY        =   11668
      _StockProps     =   1
      AutoDisplay     =   -1  'True
      ScrollBars      =   -1  'True
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   6120
      Top             =   5520
      _Version        =   65536
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   0
      CancelError     =   -1  'True
      DialogTitle     =   "Open Image"
      Filter          =   $"Form1.frx":0432
   End
   Begin VB.Menu File 
      Caption         =   "&File"
      Begin VB.Menu FileOpen 
         Caption         =   "&Open..."
      End
      Begin VB.Menu FileSave 
         Caption         =   "&Save A&s..."
      End
      Begin VB.Menu PrintFile 
         Caption         =   "&Print"
         Enabled         =   0   'False
      End
      Begin VB.Menu AdvPrint 
         Caption         =   "&Advanced Print"
      End
      Begin VB.Menu Sep2 
         Caption         =   "-"
      End
      Begin VB.Menu FileExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu editmenu 
      Caption         =   "&Edit"
      Begin VB.Menu EditPaste 
         Caption         =   "&Paste"
      End
      Begin VB.Menu EditCopyMenu 
         Caption         =   "&Copy"
         Enabled         =   0   'False
      End
   End
   Begin VB.Menu Image 
      Caption         =   "&Image"
      Begin VB.Menu FitType 
         Caption         =   "&Fit Type"
         Begin VB.Menu BestFit 
            Caption         =   "&Best Fit"
            Checked         =   -1  'True
         End
         Begin VB.Menu HorizontalFit 
            Caption         =   "&Horizontal Fit"
         End
         Begin VB.Menu VerticalFit 
            Caption         =   "&Vertical Fit"
         End
         Begin VB.Menu OneToOne 
            Caption         =   "&One To One"
         End
      End
      Begin VB.Menu RotateMenu 
         Caption         =   "&Rotate"
         Begin VB.Menu Rotate90 
            Caption         =   "&90"
         End
         Begin VB.Menu Rotate180 
            Caption         =   "&180"
         End
         Begin VB.Menu Rotate270 
            Caption         =   "&270"
         End
      End
      Begin VB.Menu ColorReduce 
         Caption         =   "&Color Reduction"
         Begin VB.Menu OrderedDither 
            Caption         =   "&Ordered"
         End
         Begin VB.Menu MedianCut 
            Caption         =   "&Median Cut"
         End
         Begin VB.Menu ErrorDiffusion 
            Caption         =   "&Error Diffusion"
         End
      End
      Begin VB.Menu Sep3 
         Caption         =   "-"
      End
      Begin VB.Menu ImageColors 
         Caption         =   "&Number of Colors..."
      End
      Begin VB.Menu ImageWidth 
         Caption         =   "&Image &Width..."
      End
      Begin VB.Menu ImageHeight 
         Caption         =   "Image &Height..."
      End
   End
   Begin VB.Menu Device 
      Caption         =   "&Device"
      Begin VB.Menu DevicePrinter 
         Caption         =   "&Printer..."
      End
      Begin VB.Menu DeviceScreen 
         Caption         =   "&Screen..."
      End
   End
   Begin VB.Menu Help 
      Caption         =   "&Help"
      Begin VB.Menu HelpAbout 
         Caption         =   "&About..."
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False

Private Sub AdvPrint_Click()
    'Prints the current image using the default printer
    'without prompting the user
    Nedimage1.AdvPrintStartDoc 0, 0, 0
    Nedimage1.AdvPrintStartPage
    
    'Print on the full page
    Nedimage1.AdvPrintImagePrint 0, 0, 0, 0
    
    Nedimage1.AdvPrintEndPage
    Nedimage1.AdvPrintEndDoc
End Sub


Private Sub BestFit_Click()
    BestFit.Checked = True
    HorizontalFit.Checked = False
    VerticalFit.Checked = False
    OneToOne.Checked = False
    Nedimage1.FitType = 0
End Sub

Private Sub DevicePrinter_Click()
    Msg = Nedimage1.NumPrinterColors
    Style = vbOKOnly
    Title = "Number of default printer colors"
    nok = MsgBox(Msg, Style, Title)
End Sub

Private Sub DeviceScreen_Click()
    Msg = Nedimage1.NumScreenColors
    Style = vbOKOnly
    Title = "Number of screen Colors"
    nok = MsgBox(Msg, Style, Title)
End Sub


Private Sub EditCopyMenu_Click()
    Nedimage1.CopyImageToClipboard
End Sub

Private Sub EditPaste_Click()
    If True = Nedimage1.CreateImageFromClipboard Then
        If False = HasError(Nedimage1.GetLastError) Then
        'If the screen only displays 256 colors, then
        'set the color reduction method to the best type
        'This is OK to do all the time since the OXC will
        'not reduce the colors on an image that is not
        'True Color
            If 256 = Nedimage1.NumScreenColors Then
                Nedimage1.MedianCutQuant
            End If
            Nedimage1.Refresh
            PrintFile.Enabled = True
            EditCopyMenu.Enabled = True
        Else
            PrintFile.Enabled = False
            EditCopyMenu.Enabled = False
        End If
    Else
        PrintFile.Enabled = False
        EditCopyMenu.Enabled = False
    End If
End Sub

Private Sub ErrorDiffusion_Click()
    Nedimage1.ErrorDiffusionDither
End Sub

Private Sub FileExit_Click()
    End
End Sub

Private Sub FileOpen_Click()

    On Error GoTo Donkey:
    CommonDialog1.Action = 1

    Nedimage1.Picture = CommonDialog1.filename
    If False = HasError(Nedimage1.GetLastError) Then
        'If the screen only displays 256 colors, then
        'set the color reduction method to the best type
        'This is OK to do all the time since the OXC will
        'not reduce the colors on an image that is not
        'True Color
        If 256 = Nedimage1.NumScreenColors Then
            Nedimage1.MedianCutQuant
        End If
        Nedimage1.Refresh
        PrintFile.Enabled = True
        EditCopyMenu.Enabled = True
    Else
        PrintFile.Enabled = False
        EditCopyMenu.Enabled = True
    End If
    
Donkey:
    Exit Sub



End Sub


Private Sub FileSave_Click()
    On Error GoTo Donkey1:
    CommonDialog2.ShowSave
    DestFile = CommonDialog2.filename
    Extension = Right$(DestFile, 3)
    Extension = UCase(Extension)
    
    Screen.MousePointer = 11
    
    If ("BMP" = Extension) Then
        Nedimage1.SaveAsBMP DestFile
    Else
        If ("DIB" = Extension) Then
            Nedimage1.SaveAsBMP DestFile
        Else
            If ("PCX" = Extension) Then
                Nedimage1.SaveAsPCX DestFile
            Else
                If ("JPG" = Extension) Then
                    'Just save at 90 for quality in demo
                    Nedimage1.SaveAsJPEG DestFile, 90
                Else
                    If ("TIF" = Extension) Then
                        Nedimage1.SaveAsTIFF DestFile
                    Else
                        Nedimage1.SaveAsTGA DestFile
                    End If
                End If
            End If
        End If
    End If

    Screen.MousePointer = 0

Donkey1:
    Exit Sub

End Sub

Private Sub Form_Resize()
    Nedimage1.Width = Form1.ScaleWidth
    Nedimage1.Height = Form1.ScaleHeight
End Sub


Private Sub HelpAbout_Click()
    Nedimage1.AboutBox
End Sub

Private Sub HorizontalFit_Click()
    BestFit.Checked = False
    HorizontalFit.Checked = True
    VerticalFit.Checked = False
    OneToOne.Checked = False
    Nedimage1.FitType = 1
End Sub


Private Sub ImageColors_Click()
    MsgBox (Nedimage1.NumImageColors)
End Sub

Private Sub ImageHeight_Click()
    MsgBox (Nedimage1.ImageHeight)
End Sub

Private Sub ImageWidth_Click()
    MsgBox (Nedimage1.ImageWidth)
End Sub


Private Sub MedianCut_Click()
    Nedimage1.MedianCutQuant
End Sub

Private Sub OneToOne_Click()
    BestFit.Checked = False
    HorizontalFit.Checked = False
    VerticalFit.Checked = False
    OneToOne.Checked = True
    Nedimage1.FitType = 3
End Sub

Private Sub OrderedDither_Click()
    Nedimage1.OrderedDither
End Sub

Private Sub PrintFile_Click()
    Nedimage1.PrintImage
End Sub

Private Sub Rotate180_Click()
    Nedimage1.Rotate180
End Sub

Private Sub Rotate270_Click()
    Nedimage1.Rotate270
End Sub


Private Sub Rotate90_Click()
    Nedimage1.Rotate90
End Sub


Private Sub VerticalFit_Click()
    BestFit.Checked = False
    HorizontalFit.Checked = False
    VerticalFit.Checked = True
    OneToOne.Checked = False
    Nedimage1.FitType = 2
End Sub


